/* graph.cpp */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "graphX.h"

/*
	special constants for node->parent. Duplicated in maxflow.cpp, both should match!
*/
#define TERMINAL ( (arc *) 1 )		/* to terminal */
#define ORPHAN   ( (arc *) 2 )		/* orphan */

template <typename captype, typename tcaptype, typename flowtype> 
	GraphX<captype, tcaptype, flowtype>::GraphX(int _node_num_max, int _edge_num_max, void (*err_function)(const char *))
	: node_num(0),
	  node_num_max(_node_num_max),
	  arc_num(0),
	  arc_num_max(2*_edge_num_max),
	  nodeptr_block(NULL),
	  error_function(err_function)
{
	nodes = (node*) malloc(node_num_max*sizeof(node));
	arcs = (arc*) malloc(arc_num_max*sizeof(arc));
	if (!nodes || !arcs) { if (error_function) (*error_function)("Not enough memory!"); exit(1); }

	maxflow_iteration = 0;
	flow = 0;
}

template <typename captype, typename tcaptype, typename flowtype> 
	GraphX<captype,tcaptype,flowtype>::~GraphX()
{
	if (nodeptr_block) 
	{ 
		delete nodeptr_block; 
		nodeptr_block = NULL; 
	}
	free(nodes);
	free(arcs);
}

template <typename captype, typename tcaptype, typename flowtype> 
	void GraphX<captype,tcaptype,flowtype>::reset()
{
	node_num = 0;
	arc_num = 0;

	if (nodeptr_block) 
	{ 
		delete nodeptr_block; 
		nodeptr_block = NULL; 
	}

	maxflow_iteration = 0;
	flow = 0;
}



#include "instancesX.inc"
