#ifndef NJAKSDTHASKJERAXJGFBZJDLAGZ
#define NJAKSDTHASKJERAXJGFBZJDLAGZ

#ifdef _MSC_VER
	#define TIMER_MSVC
#else
	//#define TIMER_GETRUSAGE
	#define TIMER_CLOCK_GETTIME
#endif

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

#ifdef TIMER_MSVC
#ifndef TIMER_DEFINED
#define TIMER_DEFINED

	#include <windows.h>

	inline double get_time()
	{
		LARGE_INTEGER t, frequency;
		QueryPerformanceCounter(&t);
		QueryPerformanceFrequency(&frequency);
		return (double)t.QuadPart/(double)frequency.QuadPart;
	}

#endif
#endif

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

#ifdef TIMER_CLOCK_GETTIME
#ifndef TIMER_DEFINED
#define TIMER_DEFINED

	#include <time.h>

	inline double get_time()
	{
		struct timespec t;
		clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &t);
		return (double)t.tv_nsec*1.00E-9 + (double)t.tv_sec;
	}

#endif
#endif

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

#ifdef TIMER_GETRUSAGE
#ifndef TIMER_DEFINED
#define TIMER_DEFINED

	#include <sys/resource.h>

	inline double get_time()
	{
		struct rusage t;
		getrusage (RUSAGE_SELF, &t);
		return (double)t.ru_utime.tv_usec*1.00E-6 + (double)t.ru_utime.tv_sec;
	}

#endif
#endif

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

#ifndef TIMER_DEFINED

	inline double get_time() { return 0; }

#endif

#endif
